/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.graphics.glutils;

import com.badlogic.gdx.Application;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.GL20;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BufferUtils;
import com.badlogic.gdx.utils.Disposable;
import com.badlogic.gdx.utils.ObjectIntMap;
import com.badlogic.gdx.utils.ObjectMap;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;

public class ShaderProgram
implements Disposable {
    public static boolean pedantic = true;
    public static String prependVertexCode = "";
    public static String prependFragmentCode = "";
    private static final ObjectMap<Application, Array<ShaderProgram>> shaders = new ObjectMap();
    private String log = "";
    private boolean isCompiled;
    private final ObjectIntMap<String> uniforms = new ObjectIntMap();
    private final ObjectIntMap<String> uniformTypes = new ObjectIntMap();
    private final ObjectIntMap<String> uniformSizes = new ObjectIntMap();
    private String[] uniformNames;
    private final ObjectIntMap<String> attributes = new ObjectIntMap();
    private final ObjectIntMap<String> attributeTypes = new ObjectIntMap();
    private final ObjectIntMap<String> attributeSizes = new ObjectIntMap();
    private String[] attributeNames;
    private int program;
    private int vertexShaderHandle;
    private int fragmentShaderHandle;
    private final FloatBuffer matrix;
    private final String vertexShaderSource;
    private final String fragmentShaderSource;
    private boolean invalidated;
    private int refCount = 0;
    static final IntBuffer intbuf = BufferUtils.newIntBuffer(1);
    IntBuffer params = BufferUtils.newIntBuffer(1);
    IntBuffer type = BufferUtils.newIntBuffer(1);

    public ShaderProgram(String vertexShader, String fragmentShader) {
        if (vertexShader == null) {
            throw new IllegalArgumentException("vertex shader must not be null");
        }
        if (fragmentShader == null) {
            throw new IllegalArgumentException("fragment shader must not be null");
        }
        if (prependVertexCode != null && prependVertexCode.length() > 0) {
            vertexShader = prependVertexCode + (String)vertexShader;
        }
        if (prependFragmentCode != null && prependFragmentCode.length() > 0) {
            fragmentShader = prependFragmentCode + (String)fragmentShader;
        }
        this.vertexShaderSource = vertexShader;
        this.fragmentShaderSource = fragmentShader;
        this.matrix = BufferUtils.newFloatBuffer(16);
        this.compileShaders((String)vertexShader, (String)fragmentShader);
        if (this.isCompiled()) {
            this.fetchAttributes();
            this.fetchUniforms();
            this.addManagedShader(Gdx.app, this);
        }
    }

    private void compileShaders(String vertexShader, String fragmentShader) {
        this.vertexShaderHandle = this.loadShader(35633, vertexShader);
        this.fragmentShaderHandle = this.loadShader(35632, fragmentShader);
        if (this.vertexShaderHandle == -1 || this.fragmentShaderHandle == -1) {
            this.isCompiled = false;
            return;
        }
        this.program = this.linkProgram(this.createProgram());
        if (this.program == -1) {
            this.isCompiled = false;
            return;
        }
        this.isCompiled = true;
    }

    private int loadShader(int type, String source) {
        GL20 gl = Gdx.gl20;
        IntBuffer intbuf = BufferUtils.newIntBuffer(1);
        int shader = gl.glCreateShader(type);
        if (shader == 0) {
            return -1;
        }
        gl.glShaderSource(shader, source);
        gl.glCompileShader(shader);
        gl.glGetShaderiv(shader, 35713, intbuf);
        int compiled = intbuf.get(0);
        if (compiled == 0) {
            String infoLog = gl.glGetShaderInfoLog(shader);
            this.log = this.log + (type == 35633 ? "Vertex shader\n" : "Fragment shader:\n");
            this.log = this.log + infoLog;
            return -1;
        }
        return shader;
    }

    protected int createProgram() {
        GL20 gl = Gdx.gl20;
        int program = gl.glCreateProgram();
        return program != 0 ? program : -1;
    }

    private int linkProgram(int program) {
        GL20 gl = Gdx.gl20;
        if (program == -1) {
            return -1;
        }
        gl.glAttachShader(program, this.vertexShaderHandle);
        gl.glAttachShader(program, this.fragmentShaderHandle);
        gl.glLinkProgram(program);
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intbuf = tmp.asIntBuffer();
        gl.glGetProgramiv(program, 35714, intbuf);
        int linked = intbuf.get(0);
        if (linked == 0) {
            this.log = Gdx.gl20.glGetProgramInfoLog(program);
            return -1;
        }
        return program;
    }

    public String getLog() {
        if (this.isCompiled) {
            this.log = Gdx.gl20.glGetProgramInfoLog(this.program);
            return this.log;
        }
        return this.log;
    }

    public boolean isCompiled() {
        return this.isCompiled;
    }

    private int fetchAttributeLocation(String name) {
        GL20 gl = Gdx.gl20;
        int location = this.attributes.get(name, -2);
        if (location == -2) {
            location = gl.glGetAttribLocation(this.program, name);
            this.attributes.put(name, location);
        }
        return location;
    }

    private int fetchUniformLocation(String name) {
        return this.fetchUniformLocation(name, pedantic);
    }

    public int fetchUniformLocation(String name, boolean pedantic) {
        int location = this.uniforms.get(name, -2);
        if (location == -2) {
            location = Gdx.gl20.glGetUniformLocation(this.program, name);
            if (location == -1 && pedantic) {
                if (this.isCompiled) {
                    throw new IllegalArgumentException("No uniform with name '" + name + "' in shader");
                }
                throw new IllegalStateException("An attempted fetch uniform from uncompiled shader \n" + this.getLog());
            }
            this.uniforms.put(name, location);
        }
        return location;
    }

    public void setUniformi(String name, int value) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform1i(location, value);
    }

    public void setUniformf(String name, float value) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchUniformLocation(name);
        gl.glUniform1f(location, value);
    }

    public void setUniformMatrix(String name, Matrix4 matrix) {
        this.setUniformMatrix(name, matrix, false);
    }

    public void setUniformMatrix(String name, Matrix4 matrix, boolean transpose) {
        this.setUniformMatrix(this.fetchUniformLocation(name), matrix, transpose);
    }

    public void setUniformMatrix(int location, Matrix4 matrix, boolean transpose) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUniformMatrix4fv(location, 1, transpose, matrix.val, 0);
    }

    public void setVertexAttribute(int location, int size, int type, boolean normalize, int stride, Buffer buffer) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glVertexAttribPointer(location, size, type, normalize, stride, buffer);
    }

    public void setVertexAttribute(int location, int size, int type, boolean normalize, int stride, int offset) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glVertexAttribPointer(location, size, type, normalize, stride, offset);
    }

    public void bind() {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glUseProgram(this.program);
    }

    @Override
    public void dispose() {
        GL20 gl = Gdx.gl20;
        gl.glUseProgram(0);
        gl.glDeleteShader(this.vertexShaderHandle);
        gl.glDeleteShader(this.fragmentShaderHandle);
        gl.glDeleteProgram(this.program);
        if (shaders.get(Gdx.app) != null) {
            shaders.get(Gdx.app).removeValue(this, true);
        }
    }

    public void disableVertexAttribute(String name) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        int location = this.fetchAttributeLocation(name);
        if (location == -1) {
            return;
        }
        gl.glDisableVertexAttribArray(location);
    }

    public void disableVertexAttribute(int location) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glDisableVertexAttribArray(location);
    }

    public void enableVertexAttribute(int location) {
        GL20 gl = Gdx.gl20;
        this.checkManaged();
        gl.glEnableVertexAttribArray(location);
    }

    private void checkManaged() {
        if (this.invalidated) {
            this.compileShaders(this.vertexShaderSource, this.fragmentShaderSource);
            this.invalidated = false;
        }
    }

    private void addManagedShader(Application app, ShaderProgram shaderProgram) {
        Array<ShaderProgram> managedResources = shaders.get(app);
        if (managedResources == null) {
            managedResources = new Array();
        }
        managedResources.add(shaderProgram);
        shaders.put(app, managedResources);
    }

    private void fetchUniforms() {
        ((Buffer)this.params).clear();
        Gdx.gl20.glGetProgramiv(this.program, 35718, this.params);
        int numUniforms = this.params.get(0);
        this.uniformNames = new String[numUniforms];
        for (int i = 0; i < numUniforms; ++i) {
            ((Buffer)this.params).clear();
            this.params.put(0, 1);
            ((Buffer)this.type).clear();
            String name = Gdx.gl20.glGetActiveUniform(this.program, i, this.params, this.type);
            int location = Gdx.gl20.glGetUniformLocation(this.program, name);
            this.uniforms.put(name, location);
            this.uniformTypes.put(name, this.type.get(0));
            this.uniformSizes.put(name, this.params.get(0));
            this.uniformNames[i] = name;
        }
    }

    private void fetchAttributes() {
        ((Buffer)this.params).clear();
        Gdx.gl20.glGetProgramiv(this.program, 35721, this.params);
        int numAttributes = this.params.get(0);
        this.attributeNames = new String[numAttributes];
        for (int i = 0; i < numAttributes; ++i) {
            ((Buffer)this.params).clear();
            this.params.put(0, 1);
            ((Buffer)this.type).clear();
            String name = Gdx.gl20.glGetActiveAttrib(this.program, i, this.params, this.type);
            int location = Gdx.gl20.glGetAttribLocation(this.program, name);
            this.attributes.put(name, location);
            this.attributeTypes.put(name, this.type.get(0));
            this.attributeSizes.put(name, this.params.get(0));
            this.attributeNames[i] = name;
        }
    }

    public int getAttributeLocation(String name) {
        return this.attributes.get(name, -1);
    }
}

