/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.StringTokenizer;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opengl.GLCapabilities;
import org.lwjgl.opengl.WGL;
import org.lwjgl.system.APIUtil;
import org.lwjgl.system.Checks;
import org.lwjgl.system.Configuration;
import org.lwjgl.system.FunctionProvider;
import org.lwjgl.system.JNI;
import org.lwjgl.system.Library;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.Platform;
import org.lwjgl.system.SharedLibrary;
import org.lwjgl.system.ThreadLocalUtil;

public final class GL {
    @Nullable
    private static final APIUtil.APIVersion MAX_VERSION;
    @Nullable
    private static FunctionProvider functionProvider;
    private static final ThreadLocal<GLCapabilities> capabilitiesTLS;
    private static ICD icd;

    private GL() {
    }

    static void initialize() {
    }

    public static void create() {
        SharedLibrary GL2;
        switch (Platform.get()) {
            case LINUX: {
                GL2 = Library.loadNative(GL.class, "org.lwjgl.opengl", Configuration.OPENGL_LIBRARY_NAME, "libGLX.so.0", "libGL.so.1", "libGL.so");
                break;
            }
            case MACOSX: {
                GL2 = Library.loadNative(GL.class, "org.lwjgl.opengl", Configuration.OPENGL_LIBRARY_NAME, "/System/Library/Frameworks/OpenGL.framework/Versions/Current/OpenGL");
                break;
            }
            case WINDOWS: {
                GL2 = Library.loadNative(GL.class, "org.lwjgl.opengl", Configuration.OPENGL_LIBRARY_NAME, "opengl32");
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        GL.create(GL2);
    }

    private static void create(SharedLibrary OPENGL) {
        try {
            GL.create((FunctionProvider)new SharedLibrary.Delegate(OPENGL){
                private final long GetProcAddress;
                {
                    long GetProcAddress = 0L;
                    switch (Platform.get()) {
                        case LINUX: {
                            GetProcAddress = this.library.getFunctionAddress("glXGetProcAddress");
                            if (GetProcAddress != 0L) break;
                            GetProcAddress = this.library.getFunctionAddress("glXGetProcAddressARB");
                            break;
                        }
                        case WINDOWS: {
                            GetProcAddress = this.library.getFunctionAddress("wglGetProcAddress");
                        }
                    }
                    if (GetProcAddress == 0L) {
                        GetProcAddress = this.library.getFunctionAddress("OSMesaGetProcAddress");
                    }
                    this.GetProcAddress = GetProcAddress;
                }

                @Override
                public long getFunctionAddress(ByteBuffer functionName) {
                    long address;
                    long l = this.GetProcAddress == 0L ? 0L : (address = Platform.get() == Platform.WINDOWS ? WGL.nwglGetProcAddress(MemoryUtil.memAddress(functionName), this.GetProcAddress) : JNI.callPP(MemoryUtil.memAddress(functionName), this.GetProcAddress));
                    if (address == 0L && (address = this.library.getFunctionAddress(functionName)) == 0L && Checks.DEBUG_FUNCTIONS) {
                        APIUtil.apiLogMissing("GL", functionName);
                    }
                    return address;
                }
            });
        }
        catch (RuntimeException e) {
            OPENGL.free();
            throw e;
        }
    }

    public static void create(FunctionProvider functionProvider) {
        if (GL.functionProvider != null) {
            throw new IllegalStateException("OpenGL library has already been loaded.");
        }
        GL.functionProvider = functionProvider;
        ThreadLocalUtil.setFunctionMissingAddresses(2228);
    }

    public static void setCapabilities(@Nullable GLCapabilities caps) {
        capabilitiesTLS.set(caps);
        ThreadLocalUtil.setCapabilities(caps == null ? 0L : MemoryUtil.memAddress(caps.addresses));
        icd.set(caps);
    }

    public static GLCapabilities getCapabilities() {
        return GL.checkCapabilities(capabilitiesTLS.get());
    }

    private static GLCapabilities checkCapabilities(@Nullable GLCapabilities caps) {
        if (Checks.CHECKS && caps == null) {
            throw new IllegalStateException("No GLCapabilities instance set for the current thread. Possible solutions:\n\ta) Call GL.createCapabilities() after making a context current in the current thread.\n\tb) Call GL.setCapabilities() if a GLCapabilities instance already exists for the current context.");
        }
        return caps;
    }

    public static GLCapabilities createCapabilities() {
        return GL.createCapabilities(null);
    }

    public static GLCapabilities createCapabilities(@Nullable IntFunction<PointerBuffer> bufferFactory) {
        return GL.createCapabilities(false, bufferFactory);
    }

    /*
     * Unable to fully structure code
     */
    public static GLCapabilities createCapabilities(boolean forwardCompatible, @Nullable IntFunction<PointerBuffer> bufferFactory) {
        functionProvider = GL.functionProvider;
        if (functionProvider == null) {
            throw new IllegalStateException("OpenGL library has not been loaded.");
        }
        GetError = functionProvider.getFunctionAddress("glGetError");
        GetString = functionProvider.getFunctionAddress("glGetString");
        GetIntegerv = functionProvider.getFunctionAddress("glGetIntegerv");
        if (GetError == 0L || GetString == 0L || GetIntegerv == 0L) {
            throw new IllegalStateException("Core OpenGL functions could not be found. Make sure that the OpenGL library has been loaded correctly.");
        }
        errorCode = JNI.callI(GetError);
        if (errorCode != 0) {
            APIUtil.apiLog(String.format("An OpenGL context was in an error state before the creation of its capabilities instance. Error: 0x%X", new Object[]{errorCode}));
        }
        stack = MemoryStack.stackPush();
        var13_8 = null;
        try {
            version = stack.ints(0);
            JNI.callPV(33307, MemoryUtil.memAddress(version), GetIntegerv);
            if (JNI.callI(GetError) == 0 && 3 <= (majorVersion = version.get(0))) {
                JNI.callPV(33308, MemoryUtil.memAddress(version), GetIntegerv);
                minorVersion = version.get(0);
            } else {
                versionString = MemoryUtil.memUTF8Safe(JNI.callP(7938, GetString));
                if (versionString == null || JNI.callI(GetError) != 0) {
                    throw new IllegalStateException("There is no OpenGL context current in the current thread.");
                }
                apiVersion = APIUtil.apiParseVersion(versionString);
                majorVersion = apiVersion.major;
                minorVersion = apiVersion.minor;
            }
        }
        catch (Throwable version) {
            var13_8 = version;
            throw version;
        }
        finally {
            if (stack != null) {
                if (var13_8 != null) {
                    try {
                        stack.close();
                    }
                    catch (Throwable version) {
                        var13_8.addSuppressed(version);
                    }
                } else {
                    stack.close();
                }
            }
        }
        if (majorVersion < 1 || majorVersion == 1 && minorVersion < 1) {
            throw new IllegalStateException("OpenGL 1.1 is required.");
        }
        GL_VERSIONS = new int[]{5, 1, 3, 6};
        supportedExtensions = new HashSet<String>(512);
        maxMajor = Math.min(majorVersion, GL_VERSIONS.length);
        if (GL.MAX_VERSION != null) {
            maxMajor = Math.min(GL.MAX_VERSION.major, maxMajor);
        }
        for (M = 1; M <= maxMajor; ++M) {
            maxMinor = GL_VERSIONS[M - 1];
            if (M == majorVersion) {
                maxMinor = Math.min(minorVersion, maxMinor);
            }
            if (GL.MAX_VERSION != null && M == GL.MAX_VERSION.major) {
                maxMinor = Math.min(GL.MAX_VERSION.minor, maxMinor);
            }
            v0 = m = M == 1 ? 1 : 0;
            while (m <= maxMinor) {
                supportedExtensions.add("OpenGL" + M + m);
                ++m;
            }
        }
        if (majorVersion < 3) {
            extensionsString = MemoryUtil.memASCIISafe(JNI.callP(7939, GetString));
            if (extensionsString != null) {
                tokenizer = new StringTokenizer(extensionsString);
                while (tokenizer.hasMoreTokens()) {
                    supportedExtensions.add(tokenizer.nextToken());
                }
            }
        } else {
            stack = MemoryStack.stackPush();
            var16_18 = null;
            try {
                pi = stack.ints(0);
                JNI.callPV(33309, MemoryUtil.memAddress(pi), GetIntegerv);
                extensionCount = pi.get(0);
                GetStringi = APIUtil.apiGetFunctionAddress(functionProvider, "glGetStringi");
                for (i = 0; i < extensionCount; ++i) {
                    supportedExtensions.add(MemoryUtil.memASCII(JNI.callP(7939, i, GetStringi)));
                }
                JNI.callPV(33310, MemoryUtil.memAddress(pi), GetIntegerv);
                if ((pi.get(0) & 1) != 0) {
                    forwardCompatible = true;
                }
                if (3 >= majorVersion && 1 > minorVersion) ** GOTO lbl110
                if (3 < majorVersion || 2 <= minorVersion) {
                    JNI.callPV(37158, MemoryUtil.memAddress(pi), GetIntegerv);
                    if ((pi.get(0) & 1) == 0) ** GOTO lbl110
                    forwardCompatible = true;
                }
                forwardCompatible = supportedExtensions.contains("GL_ARB_compatibility") == false;
            }
            catch (Throwable var17_24) {
                var16_18 = var17_24;
                throw var17_24;
            }
            finally {
                if (stack != null) {
                    if (var16_18 != null) {
                        try {
                            stack.close();
                        }
                        catch (Throwable var17_23) {
                            var16_18.addSuppressed(var17_23);
                        }
                    } else {
                        stack.close();
                    }
                }
            }
        }
lbl110:
        // 6 sources

        APIUtil.apiFilterExtensions(supportedExtensions, Configuration.OPENGL_EXTENSION_FILTER);
        caps = new GLCapabilities(functionProvider, supportedExtensions, forwardCompatible, bufferFactory == null ? (IntFunction<PointerBuffer>)LambdaMetafactory.metafactory(null, null, null, (I)Ljava/lang/Object;, createPointerBuffer(int ), (I)Lorg/lwjgl/PointerBuffer;)() : bufferFactory);
        GL.setCapabilities(caps);
        return caps;
    }

    static {
        capabilitiesTLS = new ThreadLocal();
        icd = new ICDStatic();
        Library.loadSystem(System::load, System::loadLibrary, GL.class, "org.lwjgl.opengl", Platform.mapLibraryNameBundled("lwjgl_opengl"));
        MAX_VERSION = APIUtil.apiParseVersion(Configuration.OPENGL_MAXVERSION);
        if (!Configuration.OPENGL_EXPLICIT_INIT.get(false).booleanValue()) {
            GL.create();
        }
    }

    private static class ICDStatic
    implements ICD {
        @Nullable
        private static GLCapabilities tempCaps;

        private ICDStatic() {
        }

        @Override
        public void set(@Nullable GLCapabilities caps) {
            if (tempCaps == null) {
                tempCaps = caps;
            } else if (caps != null && caps != tempCaps && ThreadLocalUtil.areCapabilitiesDifferent(ICDStatic.tempCaps.addresses, caps.addresses)) {
                APIUtil.apiLog("[WARNING] Incompatible context detected. Falling back to thread-local lookup for GL contexts.");
                icd = GL::getCapabilities;
            }
        }
    }

    private static interface ICD {
        default public void set(@Nullable GLCapabilities caps) {
        }
    }
}

